# H23 — Molecular Multi-Center Cohesion (L2 bond edges)
**PASSed reference run:** `2025-11-06T21-42-53Z`

This repo contains:
- `engine_h23_molecular_cohesion.py` — exact engine that PASSed
- `config/manifest_h23.json` — exact manifest used
- `runs/2025-11-06T21-42-53Z/` — the PASSed run's artifacts: metrics, audit, result line, env
- `run.sh` — convenience script to create a new UTC timestamped run with the same manifest

## Quick start
```bash
# (1) Optional: create and activate a Python 3.8+ environment
# (2) Run with the included manifest:
bash run.sh
```

Or, run manually:
```bash
python3 engine_h23_molecular_cohesion.py \
  --manifest config/manifest_h23.json \
  --outdir runs/<UTC_timestamp>/
```

## Verify PASS
After running, check:
- `runs/<UTC_timestamp>/outputs/run_info/result_line.txt`
- `runs/<UTC_timestamp>/outputs/metrics/h23_edges.csv`
- `runs/<UTC_timestamp>/outputs/audits/h23_audit.json`

The reference PASS line for the included run was:
```
H23 PASS=True e0-1=0.611 e0-2=0.358 e1-2=0.358 triad=0.358
```

## Notes
- The engine uses only Python stdlib; no external deps.
- JSON comments are not allowed; `config/manifest_h23.json` is comment-free by design.
- Control is deterministic; diagnostics do not feed back into control.
